<?php
header('Content-Type: application/json');
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $token = isset($data['token']) ? trim($data['token']) : '';

    if (empty($token)) {
        echo json_encode(['error' => 'توکن را وارد کنید.']);
        exit;
    }

    try {
        $stmt = $pdo->prepare('SELECT sub_link FROM tokens WHERE token = ?');
        $stmt->execute([$token]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            echo json_encode(['sub_link' => $result['sub_link']]);
        } else {
            echo json_encode(['error' => 'توکن نامعتبر است.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['error' => 'خطا: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'متد اشتباه است.']);
}
?>