<?php

// تنظیمات ربات و دیتابیس
$BOT_TOKEN = '7878841457:AAGOM1hGCLDdj09IsrsgTWrLszg-ngOQeY4'; // توکن ربات تلگرام
$API_URL = "https://api.telegram.org/bot$BOT_TOKEN/";
$DB_HOST = 'localhost';
$DB_USER = 'batmanse_vahid'; // نام کاربری دیتابیس
$DB_PASS = 'd1vahidd1@'; // رمز عبور دیتابیس
$DB_NAME = 'batmanse_vahid'; // نام دیتابیس
$BACKUP_DIR = 'backups/'; // پوشه ذخیره بکاپ‌ها
$CHAT_ID = '5305616668'; // آیدی چت تلگرام (برای ارسال فایل)
$BACKUP_INTERVAL = 3600; // بازه زمانی بکاپ‌گیری خودکار (1 ساعت = 3600 ثانیه)
$LAST_BACKUP_FILE = 'last_backup.txt'; // فایل برای ذخیره زمان آخرین بکاپ

// اطمینان از وجود پوشه بکاپ
if (!is_dir($BACKUP_DIR)) {
    mkdir($BACKUP_DIR, 0777, true);
}

// تابع ارسال درخواست به API تلگرام
function sendRequest($method, $params = []) {
    global $API_URL;
    $ch = curl_init($API_URL . $method);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: multipart/form-data']);
    $result = curl_exec($ch);
    curl_close($ch);
    return json_decode($result, true);
}

// تابع ارسال پیام به تلگرام
function sendMessage($chat_id, $text) {
    return sendRequest('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $text
    ]);
}

// تابع ارسال فایل به تلگرام
function sendFile($chat_id, $file_path) {
    return sendRequest('sendDocument', [
        'chat_id' => $chat_id,
        'document' => new CURLFile(realpath($file_path))
    ]);
}

// تابع گرفتن بکاپ و فشرده‌سازی
function createBackup() {
    global $DB_HOST, $DB_USER, $DB_PASS, $DB_NAME, $BACKUP_DIR;
    
    // نام فایل بکاپ با timestamp
    $timestamp = date('Y-m-d_H-i-s');
    $sql_file = $BACKUP_DIR . "backup_$timestamp.sql";
    $zip_file = $BACKUP_DIR . "backup_$timestamp.zip";
    
    // اجرای دستور mysqldump برای گرفتن بکاپ
    $command = "mysqldump --host=$DB_HOST --user=$DB_USER --password=$DB_PASS $DB_NAME > $sql_file";
    exec($command, $output, $return_var);
    
    if ($return_var !== 0) {
        return ['success' => false, 'error' => 'Failed to create SQL backup'];
    }
    
    // فشرده‌سازی فایل SQL به ZIP
    $zip = new ZipArchive();
    if ($zip->open($zip_file, ZipArchive::CREATE) === TRUE) {
        $zip->addFile($sql_file, basename($sql_file));
        $zip->close();
        
        // حذف فایل SQL پس از فشرده‌سازی
        unlink($sql_file);
        
        return ['success' => true, 'file' => $zip_file];
    }
    
    return ['success' => false, 'error' => 'Failed to create ZIP file'];
}

// تابع بررسی و اجرای بکاپ خودکار
function autoBackup() {
    global $CHAT_ID, $BACKUP_INTERVAL, $LAST_BACKUP_FILE;
    
    $current_time = time();
    $last_backup = file_exists($LAST_BACKUP_FILE) ? (int)file_get_contents($LAST_BACKUP_FILE) : 0;
    
    // بررسی اینکه آیا یک ساعت از آخرین بکاپ گذشته است
    if (($current_time - $last_backup) >= $BACKUP_INTERVAL) {
        sendMessage($CHAT_ID, 'Starting automatic backup...');
        
        $backup = createBackup();
        
        if ($backup['success']) {
            $result = sendFile($CHAT_ID, $backup['file']);
            
            if ($result['ok']) {
                sendMessage($CHAT_ID, 'Automatic backup created and sent successfully!');
                // به‌روزرسانی زمان آخرین بکاپ
                file_put_contents($LAST_BACKUP_FILE, $current_time);
                // حذف فایل ZIP پس از ارسال
                unlink($backup['file']);
            } else {
                sendMessage($CHAT_ID, 'Failed to send automatic backup file.');
            }
        } else {
            sendMessage($CHAT_ID, 'Error in automatic backup: ' . $backup['error']);
        }
    }
}

// دریافت آپدیت‌های ربات
$update = json_decode(file_get_contents('php://input'), true);

// بررسی پیام دریافتی
if (isset($update['message']['text']) && $update['message']['text'] === '/start') {
    $chat_id = $update['message']['chat']['id'];
    
    // بررسی اینکه آیا کاربر مجاز است (CHAT_ID)
    if ($chat_id == $CHAT_ID) {
        sendMessage($chat_id, 'Starting backup process...');
        
        // گرفتن بکاپ
        $backup = createBackup();
        
        if ($backup['success']) {
            // ارسال فایل ZIP به تلگرام
            $result = sendFile($chat_id, $backup['file']);
            
            if ($result['ok']) {
                sendMessage($chat_id, 'Backup created and sent successfully!');
                // حذف فایل ZIP پس از ارسال
                unlink($backup['file']);
            } else {
                sendMessage($chat_id, 'Failed to send backup file.');
            }
        } else {
            sendMessage($chat_id, 'Error: ' . $backup['error']);
        }
    } else {
        sendMessage($chat_id, 'Unauthorized access. This bot is restricted to a specific user.');
    }
}

// اجرای بکاپ خودکار (هر بار که اسکریپت اجرا می‌شود)
autoBackup();