<?php
session_start(); // شروع سشن برای مدیریت لاگین

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    // اگر کاربر لاگین نکرده باشد، فرم لاگین نمایش داده می‌شود
    $error = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        $password = $_POST['password'];
        include 'log.php'; // اتصال به log.php برای بررسی رمز عبور
    }
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>ورود به پنل مدیریت</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Lalezar&display=swap" rel="stylesheet">
        <style>
            :root {
                --primary-color: #6c5ce7;
                --secondary-color: #a29bfe;
                --dark-color: #2d3436;
                --light-color: #f5f6fa;
                --success-color: #00b894;
                --danger-color: #d63031;
                --border-radius: 12px;
                --box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
                --transition: all 0.3s ease;
            }

            body {
                font-family: 'Lalezar', sans-serif;
                background-color: var(--light-color);
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
                margin: 0;
                color: var(--dark-color);
            }

            body.dark-mode {
                background-color: #1a1a1a;
                color: #f0f0f0;
            }

            body.dark-mode .login-container {
                background-color: #2d2d2d;
                border-color: #444;
            }

            body.dark-mode .form-control {
                background-color: #333;
                color: #f0f0f0;
                border-color: #555;
            }

            body.dark-mode .form-control:focus {
                background-color: #444;
                color: #fff;
                border-color: var(--primary-color);
                box-shadow: 0 0 0 0.25rem rgba(108, 92, 231, 0.25);
            }

            .login-container {
                max-width: 400px;
                width: 100%;
                padding: 2rem;
                background: white;
                border-radius: var(--border-radius);
                box-shadow: var(--box-shadow);
            }

            .btn-primary {
                background-color: var(--primary-color);
                border-color: var(--primary-color);
                border-radius: var(--border-radius);
                padding: 0.5rem 1.5rem;
                transition: var(--transition);
            }

            .btn-primary:hover {
                background-color: #5649d1;
                border-color: #5649d1;
                transform: translateY(-2px);
            }

            .alert {
                border-radius: var(--border-radius);
            }

            .theme-toggle {
                position: fixed;
                bottom: 20px;
                right: 20px;
                width: 50px;
                height: 50px;
                border-radius: 50%;
                background-color: var(--primary-color);
                color: white;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
                z-index: 1000;
                transition: var(--transition);
            }

            .theme-toggle:hover {
                transform: scale(1.1);
            }

            .svg-icon {
                width: 20px;
                height: 20px;
                vertical-align: middle;
                margin-left: 5px;
            }
        </style>
    </head>
    <body>
        <div class="theme-toggle" id="themeToggle">
            <svg id="themeIcon" class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 2a10 10 0 00-9.24 6.17 10.03 10.03 0 0012.07 12.07A10 10 0 0012 2zm0 18a8 8 0 110-16 8 8 0 010 16z"></path>
            </svg>
        </div>

        <div class="login-container">
            <h3 class="text-center mb-4">
                <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"></path>
                </svg>
                ورود به پنل مدیریت
            </h3>
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            <form method="POST">
                <div class="mb-3">
                    <label for="password" class="form-label">رمز عبور</label>
                    <input type="password" name="password" id="password" class="form-control" placeholder="رمز عبور را وارد کنید" required>
                </div>
                <div class="text-center">
                    <button type="submit" name="login" class="btn btn-primary">
                        <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"></path>
                        </svg>
                        ورود
                    </button>
                </div>
            </form>
        </div>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script>
            const themeToggle = document.getElementById('themeToggle');
            const themeIcon = document.getElementById('themeIcon');
            const body = document.body;

            if (localStorage.getItem('darkMode') === 'enabled') {
                body.classList.add('dark-mode');
                themeIcon.innerHTML = '<path d="M12 2a10 10 0 0110 10 10 10 0 01-10 10A10 10 0 012 12 10 10 0 0112 2zm0 2a8 8 0 00-8 8 8 8 0 008 8 8 8 0 008-8 8 8 0 00-8-8z"/>';
            }

            themeToggle.addEventListener('click', () => {
                body.classList.toggle('dark-mode');
                if (body.classList.contains('dark-mode')) {
                    themeIcon.innerHTML = '<path d="M12 2a10 10 0 0110 10 10 10 0 01-10 10A10 10 0 012 12 10 10 0 0112 2zm0 2a8 8 0 00-8 8 8 8 0 008 8 8 8 0 008-8 8 8 0 00-8-8z"/>';
                    localStorage.setItem('darkMode', 'enabled');
                } else {
                    themeIcon.innerHTML = '<path d="M12 2a10 10 0 00-9.24 6.17 10.03 10.03 0 0012.07 12.07A10 10 0 0012 2zm0 18a8 8 0 110-16 8 8 0 010 16z"/>';
                    localStorage.setItem('darkMode', 'disabled');
                }
            });
        </script>
    </body>
    </html>
    <?php
    exit; // خروج از اسکریپت اگر کاربر لاگین نکرده باشد
}

// ادامه کد برای کاربران لاگین شده
require_once 'config.php'; // اتصال به config.php برای مدیریت توکن‌ها

// بررسی وجود متغیر $pdo
if (!isset($pdo)) {
    die('خطا: اتصال به دیتابیس برقرار نشد. لطفاً فایل config.php را بررسی کنید.');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        if (isset($_POST['add_token'])) {
            $token = trim($_POST['token']);
            $sub_link = trim($_POST['sub_link']);

            if (empty($token) || empty($sub_link)) {
                $error = 'توکن و لینک ساب را وارد کنید.';
            } else {
                // بررسی وجود توکن
                $stmt = $pdo->prepare('SELECT COUNT(*) FROM tokens WHERE token = ?');
                $stmt->execute([$token]);
                if ($stmt->fetchColumn() > 0) {
                    $error = 'کاربری با این توکن قبلاً ثبت شده است.';
                } else {
                    $stmt = $pdo->prepare('INSERT INTO tokens (token, sub_link) VALUES (?, ?)');
                    $stmt->execute([$token, $sub_link]);
                    $success = 'توکن با موفقیت اضافه شد.';
                }
            }
        } elseif (isset($_POST['delete_token'])) {
            $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
            if ($id === false || $id === null) {
                $error = 'شناسه توکن نامعتبر است.';
            } else {
                $stmt = $pdo->prepare('DELETE FROM tokens WHERE id = ?');
                $stmt->execute([$id]);
                $success = 'توکن با موفقیت حذف شد.';
            }
        } elseif (isset($_POST['edit_token'])) {
            $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
            $token = trim($_POST['token']);
            $sub_link = trim($_POST['sub_link']);
            if ($id === false || $id === null) {
                $error = 'شناسه توکن نامعتبر است.';
            } elseif (empty($token) || empty($sub_link)) {
                $error = 'توکن و لینک ساب را وارد کنید.';
            } else {
                $stmt = $pdo->prepare('UPDATE tokens SET token = ?, sub_link = ? WHERE id = ?');
                $stmt->execute([$token, $sub_link, $id]);
                $success = 'توکن با موفقیت ویرایش شد.';
            }
        } elseif (isset($_POST['logout'])) {
            session_unset();
            session_destroy();
            header('Location: index.php');
            exit;
        }
    } catch (PDOException $e) {
        $error = 'خطا در عملیات دیتابیس: ' . $e->getMessage();
    }
}

// جستجو
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$search_query = $search ? 'WHERE token LIKE ?' : '';
$search_param = $search ? ["%$search%"] : [];

try {
    $stmt = $pdo->prepare("SELECT id, token, sub_link FROM tokens $search_query ORDER BY id DESC");
    $stmt->execute($search_param);
    $tokens = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $total_tokens = count($tokens);
} catch (PDOException $e) {
    $error = 'خطا در دریافت توکن‌ها: ' . $e->getMessage();
    $tokens = [];
    $total_tokens = 0;
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مدیریت توکن‌ها | پنل مدیریت</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Lalezar&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #6c5ce7;
            --secondary-color: #a29bfe;
            --dark-color: #2d3436;
            --light-color: #f5f6fa;
            --success-color: #00b894;
            --danger-color: #d63031;
            --border-radius: 12px;
            --box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        body {
            font-family: 'Lalezar', sans-serif;
            background-color: var(--light-color);
            color: var(--dark-color);
            transition: var(--transition);
        }

        body.dark-mode {
            background-color: #1a1a1a;
            color: #f0f0f0;
        }

        body.dark-mode .card {
            background-color: #2d2d2d;
            border-color: #444;
        }

        body.dark-mode .table, body.dark-mode .sub-links-container {
            color: #f0f0f0;
            background-color: #2d2d2d;
        }

        body.dark-mode .form-control {
            background-color: #333;
            color: #f0f0f0;
            border-color: #555;
        }

        body.dark-mode .form-control:focus {
            background-color: #444;
            color: #fff;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(108, 92, 231, 0.25);
        }

        .card {
            border-radius: var(--border-radius);
            border: none;
            box-shadow: var(--box-shadow);
            overflow: hidden;
            margin-bottom: 2rem;
        }

        .card-header {
            background-color: var(--primary-color);
            color: white;
            padding: 1.5rem;
            border-bottom: none;
            font-size: 1.5rem;
        }

        .card-body {
            padding: 2rem;
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            border-radius: var(--border-radius);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: var(--transition);
        }

        .btn-primary:hover {
            background-color: #5649d1;
            border-color: #5649d1;
            transform: translateY(-2px);
        }

        .btn-danger {
            background-color: var(--danger-color);
            border-color: var(--danger-color);
            border-radius: var(--border-radius);
        }

        .btn-warning {
            background-color: #f39c12;
            border-color: #f39c12;
            border-radius: var(--border-radius);
        }

        .btn-danger:hover {
            background-color: #c0392b;
            border-color: #c0392b;
        }

        .table th {
            background-color: var(--secondary-color);
            color: white;
            font-weight: 500;
        }

        .alert {
            border-radius: var(--border-radius);
            padding: 1rem;
        }

        .theme-toggle {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background-color: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            z-index: 1000;
            transition: var(--transition);
        }

        .theme-toggle:hover {
            transform: scale(1.1);
        }

        .token-badge {
            background-color: var(--secondary-color);
            color: white;
            padding: 0.3rem 0.6rem;
            border-radius: 20px;
            font-size: 0.9rem;
            display: inline-block;
            margin: 0.2rem;
            cursor: pointer;
        }

        .copy-badge {
            background-color: #17a2b8;
            color: white;
            padding: 0.3rem 0.6rem;
            border-radius: 20px;
            font-size: 0.9rem;
            display: inline-block;
            margin: 0.2rem;
            cursor: pointer;
        }

        .copy-badge:hover {
            background-color: #138496;
        }

        .sub-links-container {
            display: none;
            background-color: #f8f9fa;
            padding: 1rem;
            border-radius: var(--border-radius);
            margin-top: 0.5rem;
            word-break: break-all;
        }

        body.dark-mode .sub-links-container {
            background-color: #333;
        }

        .sub-link-item {
            background-color: var(--primary-color);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-size: 0.9rem;
            text-decoration: none;
            display: inline-block;
            margin-top: 0.5rem;
            transition: var(--transition);
        }

        .sub-link-item:hover {
            background-color: #5649d1;
            transform: translateY(-2px);
        }

        .svg-icon {
            width: 20px;
            height: 20px;
            vertical-align: middle;
            margin-left: 5px;
            transition: transform 0.3s ease;
        }

        .svg-icon.rotate {
            transform: rotate(90deg);
        }

        .token-count {
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 1rem;
            border-radius: var(--border-radius);
            text-align: center;
            font-size: 1.2rem;
            margin-bottom: 1rem;
        }

        .action-buttons {
            margin-top: 1rem;
            display: flex;
            gap: 0.5rem;
            justify-content: center;
        }

        .toast {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 2000;
            min-width: 200px;
        }

        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }

            .sub-links-container {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="theme-toggle" id="themeToggle">
        <svg id="themeIcon" class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 2a10 10 0 00-9.24 6.17 10.03 10.03 0 0012.07 12.07A10 10 0 0012 2zm0 18a8 8 0 110-16 8 8 0 010 16z"></path>
        </svg>
    </div>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card">
                    <div class="card-header text-center">
                        <h3 class="mb-0">
                            <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm0-12c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z"></path>
                            </svg>
                            مدیریت توکن‌ها
                        </h3>
                        <form method="POST" class="d-inline">
                            <button type="submit" name="logout" class="btn btn-danger btn-sm">خروج</button>
                        </form>
                    </div>
                    <div class="card-body">
                        <?php if ($error): ?>
                            <div class="alert alert-danger alert-dismissible fade show">
                                <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"></path>
                                </svg>
                                <?php echo htmlspecialchars($error); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                        <?php if ($success): ?>
                            <div class="alert alert-success alert-dismissible fade show">
                                <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"></path>
                                </svg>
                                <?php echo htmlspecialchars($success); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                        <div class="mb-5">
                            <h5 class="mb-4 text-center">
                                <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z"></path>
                                </svg>
                                افزودن توکن جدید
                            </h5>
                            <form method="POST" class="row g-3">
                                <div class="col-12 text-center mb-3">
                                    <button type="button" id="generateRandomToken" class="btn btn-warning">
                                        <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm0-12c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z"></path>
                                        </svg>
                                        تولید توکن تصادفی
                                    </button>
                                </div>
                                <div class="col-md-6">
                                    <label for="token" class="form-label">توکن</label>
                                    <input type="text" name="token" id="token" class="form-control" placeholder="توکن را وارد کنید" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="sub_link" class="form-label">لینک ساب</label>
                                    <input type="text" name="sub_link" id="sub_link" class="form-control" placeholder="لینک ساب را وارد کنید" required>
                                </div>
                                <div class="col-12 text-center mt-3">
                                    <button type="submit" name="add_token" class="btn btn-primary px-4">
                                        <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z"></path>
                                        </svg>
                                        افزودن توکن
                                    </button>
                                </div>
                            </form>
                        </div>

                        <hr class="my-4">

                        <div class="mt-5">
                            <h5 class="mb-4 text-center">
                                <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M3 6v12a2 2 0 002 2h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2zm2 0h14v12H5V6zm2 2h10v2H7V8zm0 4h10v2H7v-2zm0 4h7v2H7v-2z"></path>
                                </svg>
                                لیست توکن‌های موجود
                            </h5>
                            <div class="token-count">
                                تعداد توکن‌ها: <?php echo htmlspecialchars($total_tokens); ?>
                            </div>
                            <form method="GET" class="mb-4">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="جستجوی توکن" value="<?php echo htmlspecialchars($search); ?>">
                                    <button type="submit" class="btn btn-primary">
                                        <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0016 9.5 6.5 6.5 0 109.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"></path>
                                        </svg>
                                        جستجو
                                    </button>
                                </div>
                            </form>
                            <?php if (empty($tokens)): ?>
                                <div class="alert alert-info text-center">
                                    <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"></path>
                                    </svg>
                                    هیچ توکنی ثبت نشده است.
                                </div>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead class="table-primary">
                                            <tr>
                                                <th>توکن</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($tokens as $token): ?>
                                                <tr>
                                                    <td>
                                                        <div style="display: flex; align-items: center; gap: 0.5rem;">
                                                            <span class="copy-badge" data-token="<?php echo htmlspecialchars($token['token']); ?>" title="کپی توکن">
                                                                <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                                                    <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"></path>
                                                                </svg>
                                                            </span>
                                                            <span class="token-badge toggle-sub-link" data-target="subLinks<?php echo htmlspecialchars($token['id']); ?>">
                                                                <svg class="svg-icon toggle-icon" fill="currentColor" viewBox="0 0 24 24">
                                                                    <path d="M10 17l5-5-5-5v10z"></path>
                                                                </svg>
                                                            </span>
                                                            <span><?php echo htmlspecialchars($token['token']); ?></span>
                                                        </div>
                                                        <div class="sub-links-container" id="subLinks<?php echo htmlspecialchars($token['id']); ?>">
                                                            <div><strong>توکن:</strong> <?php echo htmlspecialchars($token['token']); ?></div>
                                                            <div><strong>لینک ساب:</strong> <a href="<?php echo htmlspecialchars($token['sub_link']); ?>" target="_blank" class="sub-link-item"><?php echo htmlspecialchars($token['sub_link']); ?></a></div>
                                                            <div class="action-buttons">
                                                                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editModal<?php echo htmlspecialchars($token['id']); ?>">
                                                                    <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                                                        <path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path>
                                                                    </svg>
                                                                    ویرایش
                                                                </button>
                                                                <form method="POST" class="d-inline">
                                                                    <input type="hidden" name="id" value="<?php echo htmlspecialchars($token['id']); ?>">
                                                                    <button type="submit" name="delete_token" class="btn btn-danger btn-sm">
                                                                        <svg class="svg-icon" fill="currentColor" viewBox="0 0 24 24">
                                                                            <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"></path>
                                                                        </svg>
                                                                        حذف
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                        <!-- Modal for Edit -->
                                                        <div class="modal fade" id="editModal<?php echo htmlspecialchars($token['id']); ?>" tabindex="-1" aria-labelledby="editModalLabel<?php echo htmlspecialchars($token['id']); ?>" aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="editModalLabel<?php echo htmlspecialchars($token['id']); ?>">ویرایش توکن</h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <form method="POST">
                                                                            <input type="hidden" name="id" value="<?php echo htmlspecialchars($token['id']); ?>">
                                                                            <div class="mb-3">
                                                                                <label for="edit_token_<?php echo htmlspecialchars($token['id']); ?>" class="form-label">توکن</label>
                                                                                <input type="text" name="token" id="edit_token_<?php echo htmlspecialchars($token['id']); ?>" class="form-control" value="<?php echo htmlspecialchars($token['token']); ?>" required>
                                                                            </div>
                                                                            <div class="mb-3">
                                                                                <label for="edit_sub_link_<?php echo htmlspecialchars($token['id']); ?>" class="form-label">لینک ساب</label>
                                                                                <input type="text" name="sub_link" id="edit_sub_link_<?php echo htmlspecialchars($token['id']); ?>" class="form-control" value="<?php echo htmlspecialchars($token['sub_link']); ?>" required>
                                                                            </div>
                                                                            <button type="submit" name="edit_token" class="btn btn-primary">ذخیره تغییرات</button>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const themeToggle = document.getElementById('themeToggle');
        const themeIcon = document.getElementById('themeIcon');
        const body = document.body;

        if (localStorage.getItem('darkMode') === 'enabled') {
            body.classList.add('dark-mode');
            themeIcon.innerHTML = '<path d="M12 2a10 10 0 0110 10 10 10 0 01-10 10A10 10 0 012 12 10 10 0 0112 2zm0 2a8 8 0 00-8 8 8 8 0 008 8 8 8 0 008-8 8 8 0 00-8-8z"/>';
        }

        themeToggle.addEventListener('click', () => {
            body.classList.toggle('dark-mode');
            if (body.classList.contains('dark-mode')) {
                themeIcon.innerHTML = '<path d="M12 2a10 10 0 0110 10 10 10 0 01-10 10A10 10 0 012 12 10 10 0 0112 2zm0 2a8 8 0 00-8 8 8 8 0 008 8 8 8 0 008-8 8 8 0 00-8-8z"/>';
                localStorage.setItem('darkMode', 'enabled');
            } else {
                themeIcon.innerHTML = '<path d="M12 2a10 10 0 00-9.24 6.17 10.03 10.03 0 0012.07 12.07A10 10 0 0012 2zm0 18a8 8 0 110-16 8 8 0 010 16z"/>';
                localStorage.setItem('darkMode', 'disabled');
            }
        });

        document.querySelectorAll('.toggle-sub-link').forEach(badge => {
            badge.addEventListener('click', () => {
                const targetId = badge.getAttribute('data-target');
                const subLinkContainer = document.getElementById(targetId);
                const icon = badge.querySelector('.toggle-icon');
                if (subLinkContainer.style.display === 'block') {
                    subLinkContainer.style.display = 'none';
                    icon.classList.remove('rotate');
                } else {
                    subLinkContainer.style.display = 'block';
                    icon.classList.add('rotate');
                }
            });
        });

        document.querySelectorAll('.copy-badge').forEach(badge => {
            badge.addEventListener('click', () => {
                const token = badge.getAttribute('data-token');
                navigator.clipboard.writeText(token).then(() => {
                    const toast = document.createElement('div');
                    toast.className = 'toast align-items-center text-white bg-success border-0';
                    toast.setAttribute('role', 'alert');
                    toast.setAttribute('aria-live', 'assertive');
                    toast.setAttribute('aria-atomic', 'true');
                    toast.innerHTML = `
                        <div class="d-flex">
                            <div class="toast-body">
                                توکن با موفقیت کپی شد!
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                        </div>
                    `;
                    document.body.appendChild(toast);
                    const bootstrapToast = new bootstrap.Toast(toast);
                    bootstrapToast.show();
                    setTimeout(() => {
                        toast.remove();
                    }, 3000);
                }).catch(err => {
                    console.error('خطا در کپی کردن توکن:', err);
                });
            });
        });

        document.getElementById('generateRandomToken').addEventListener('click', () => {
            const randomNum = Math.floor(100000 + Math.random() * 900000);
            const token = `batman-${randomNum}`;
            document.getElementById('token').value = token;
        });

        document.querySelectorAll('.token-badge').forEach(badge => {
            badge.setAttribute('title', 'باز/بستن جزئیات');
        });
    </script>
</body>
</html>