<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>داشبورد</title>
    <link href="https://fonts.googleapis.com/css2?family=Lalezar&display=swap" rel="stylesheet">
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <style>
        body {
            margin: 0;
            font-family: 'Lalezar', sans-serif;
            background: linear-gradient(135deg, #ff5252, #ff1744);
            color: #fff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        /* پوشش پس‌زمینه برای بستن منو */
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.4);
            display: none;
            z-index: 99;
        }

        /* منوی کناری */
        .sidebar {
            width: 200px;
            height: 100vh;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(15px);
            position: fixed;
            left: -210px;
            top: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding-top: 10px;
            transition: 0.4s;
            box-shadow: 4px 0 10px rgba(0, 0, 0, 0.2);
            border-radius: 0 15px 15px 0;
            z-index: 100;
        }

        .sidebar.active {
            left: 0;
        }

        /* دکمه بستن منو */
        .close-btn {
            font-size: 2rem;
            cursor: pointer;
            color: white;
            margin-bottom: 15px;
            transition: 0.3s;
        }

        .close-btn:hover {
            color: #ffccbc;
        }

        /* نمایش ایمیل */
        .email-panel {
            font-size: 0.9rem;
            background: #d32f2f;
            padding: 6px 10px;
            border-radius: 6px;
            color: white;
            text-align: center;
            width: 85%;
            box-shadow: 2px 2px 8px rgba(0, 0, 0, 0.2);
            margin-bottom: 20px;
        }

        .menu-item {
            width: 90%;
            padding: 8px;
            margin: 5px 0;
            text-align: center;
            border-radius: 8px;
            text-decoration: none;
            color: #fff;
            font-size: 0.9rem;
            font-weight: bold;
            background: rgba(255, 255, 255, 0.25);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            box-shadow: inset 1px 1px 3px rgba(0, 0, 0, 0.2);
            transition: 0.3s;
        }

        .menu-item:hover {
            background: rgba(255, 255, 255, 0.4);
            transform: scale(1.03);
        }

        .logout-btn {
            font-size: 0.8rem;
            background: #c62828;
            padding: 6px 14px;
            border-radius: 14px;
            text-decoration: none;
            color: #fff;
            box-shadow: 1px 1px 5px rgba(0, 0, 0, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
            margin-top: auto;
            margin-bottom: 20px;
        }

        .logout-btn:hover {
            background: #b71c1c;
        }

        /* دکمه باز کردن منو */
        .menu-btn {
            position: absolute;
            left: 10px;
            top: 10px;
            font-size: 1.8rem;
            color: white;
            background: rgba(0, 0, 0, 0.3);
            padding: 8px 12px;
            border-radius: 50%;
            cursor: pointer;
            transition: 0.3s;
        }

        .menu-btn:hover {
            background: rgba(0, 0, 0, 0.5);
        }

        /* آیکون ها */
        .fa {
            font-size: 1.2rem;
        }
    </style>
    <script>
        function toggleSidebar() {
            let sidebar = document.querySelector('.sidebar');
            let overlay = document.querySelector('.overlay');
            sidebar.classList.toggle('active');
            overlay.style.display = sidebar.classList.contains('active') ? 'block' : 'none';
        }

        function closeSidebar() {
            document.querySelector('.sidebar').classList.remove('active');
            document.querySelector('.overlay').style.display = 'none';
        }

        document.addEventListener("click", function(event) {
            let sidebar = document.querySelector('.sidebar');
            let menuBtn = document.querySelector('.menu-btn');
            let closeBtn = document.querySelector('.close-btn');
            if (!sidebar.contains(event.target) && !menuBtn.contains(event.target) && event.target !== closeBtn) {
                closeSidebar();
            }
        });
    </script>
</head>
<body>

<!-- پس‌زمینه برای خروج از منو با کلیک بیرون -->
<div class="overlay" onclick="closeSidebar()"></div>

<!-- دکمه باز کردن منو -->
<div class="menu-btn" onclick="toggleSidebar()">☰</div>

<!-- منوی کناری -->
<div class="sidebar">
    <span class="close-btn" onclick="closeSidebar()">←</span>

    <!-- نمایش ایمیل در بالا -->
    <div class="email-panel"><?php echo $_SESSION['email']; ?></div>

    <!-- گزینه‌های منو -->
    <a href="create_service.php" class="menu-item"><i class="fa fa-plus-circle"></i> ساخت سرویس</a>
    <a href="my_services.php" class="menu-item"><i class="fa fa-list"></i> سرویس‌های من</a>
    <a href="test.php" class="menu-item"><i class="fa fa-vial"></i> اکانت تست</a>
    <a href="my_testservices.php" class="menu-item"><i class="fa fa-user-check"></i> اکانت‌های تست من</a>
    <a href="change" class="menu-item"><i class="fa fa-sync"></i> تعویض لینک</a>
    <a href="qr.html" class="menu-item"><i class="fa fa-sync"></i> تبدیل لینک به qr</a>
    
    
    <!-- دکمه خروج در پایین -->
    <a href="login.php" class="logout-btn"><i class="fa fa-sign-out-alt"></i> خروج</a>
</div>

<!-- محتوای اصلی -->
<div class="content">
    خوش آمدید به داشبورد
</div>

</body>
</html>
