<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

$username = isset($_POST['username']) ? $_POST['username'] : '';
$panel_file = 'pannel/pannel.txt';

if (empty($username)) {
    die("خطا: نام کاربری انتخاب نشده است.");
}

if (file_exists($panel_file)) {
    $panel_data = file($panel_file, FILE_IGNORE_NEW_LINES);
    $panel_url = $panel_data[0];
    $username_panel = $panel_data[1];
    $password_panel = $panel_data[2];
} else {
    die("فایل اطلاعات پنل یافت نشد.");
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>تمدید کاربر</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7;
            margin: 0;
            padding: 20px;
        }
        form {
            max-width: 400px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        label {
            display: block;
            margin-bottom: 5px;
        }
        input[type="number"], input[type="checkbox"] {
            width: 100%;
            padding: 8px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        button {
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <h1>تمدید کاربر <?php echo htmlspecialchars($username); ?></h1>
    <form action="process_extend.php" method="POST">
        <input type="hidden" name="username" value="<?php echo htmlspecialchars($username); ?>">

        <label for="volume">حجم (GB):</label>
        <input type="number" id="volume" name="volume" required>

        <label for="duration">مدت زمان (روز):</label>
        <input type="number" id="duration" name="duration" required>

        <label>
            <input type="checkbox" name="reset_usage" value="1">
            بازنشانی حجم مصرفی
        </label>

        <button type="submit">تمدید</button>
    </form>
</body>
</html>