<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;700&display=swap');
        @import url('https://fonts.googleapis.com/css2?family=Roboto+Slab:wght@400;700&display=swap');

        body {
            background: linear-gradient(135deg, #ffb3c6, #ffd1e4, #f7e6f9);
            font-family: 'Vazirmatn', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            direction: rtl;
            overflow: hidden;
        }

        .container {
            background: rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.2);
            padding: 40px;
            max-width: 300px;
            width: 100%;
            text-align: center;
            animation: fadeIn 1.2s ease-out;
        }

        @keyframes fadeIn {
            0% { opacity: 0; transform: translateY(20px); }
            100% { opacity: 1; transform: translateY(0); }
        }

        h1 {
            font-family: 'Roboto Slab', serif;
            font-size: 32px;
            color: #d84c5f;
            margin-bottom: 20px;
            background: linear-gradient(90deg, #ff758c, #ffb199);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #444;
            text-align: right;
            font-size: 14px;
            font-weight: bold;
        }

        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid rgba(255, 255, 255, 0.5);
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.2);
            color: #333;
            font-size: 14px;
            box-sizing: border-box;
        }

        input:focus {
            border-color: #d84c5f;
            box-shadow: 0 0 8px rgba(216, 76, 95, 0.5);
            outline: none;
        }

        button {
            background: linear-gradient(135deg, #ff758c, #ffb199);
            color: white;
            padding: 12px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
        }

        button:hover {
            background: linear-gradient(135deg, #ff6379, #ff9fa8);
            transform: scale(1.05);
        }

        .forgot-password {
            display: inline-block;
            margin-top: 10px;
            color: #ff758c;
            font-size: 14px;
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s ease;
        }

        .forgot-password:hover {
            color: #d84c5f;
        }

        footer {
            margin-top: 20px;
            font-size: 12px;
            color: #555;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>ᐯ丨卩 卩丨几Ꮆ</h1>
        <form method="POST" action="login_process.php">
            <label for="email">ایمیل:</label>
            <input type="email" id="email" name="email" required>
            <label for="password">رمز عبور:</label>
            <input type="password" id="password" name="password" required>
            <button type="submit">ورود</button>
        </form>
        <!-- دکمه جدید برای فراموشی رمز عبور -->
        <a href="/admin" class="forgot-password">پسورد خود را فراموش کرده‌ام</a>
        <footer>© 2024 VIP Ping - تمامی حقوق محفوظ است.</footer>
    </div>
</body>
</html>
