<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

$email = $_SESSION['email'];
$file = "services/$email.txt";
$services = file_exists($file) ? file($file) : [];
$num_services = count($services); // تعداد سرویس‌های کاربر
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>My Services</title>
    <style>
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        @import url('https://fonts.googleapis.com/css2?family=Lalezar&display=swap');

        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #C05555, #ff5722); /* رنگ‌های ملایم‌تر */
            color: #ffffff;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            height: 100vh;
            direction: rtl;
            animation: fadeIn 1s ease-in-out;
        }

        .container {
            margin-top: 40%; 
            max-width: 800px;
            width: 100%;
            padding: 20px;
            box-sizing: border-box;
            text-align: center;
        }

        h2 {
            font-family: 'Lalezar', cursive;
            font-size: 2.5rem;
            color: #fff;
            margin-bottom: 15px;
            text-shadow: 0 0 10px rgba(0, 0, 0, 0.5); /* سایه برای متن عنوان */
        }

        .circle-info-container {
            margin-bottom: 30px;
        }

        .circle-info {
            display: inline-block;
            background-color: #E07F7F;
            color: white;
            border-radius: 50%;
            width: 200px;
            height: 200px;
            line-height: 200px;
            font-size: 3.5rem;
            font-weight: bold;
            margin-bottom: 20px;
            position: relative;
            text-align: center;
            border: 10px solid #802828;
            box-shadow: 0 0 30px rgba(255, 87, 34, 0.8), 0 0 20px rgba(0, 0, 0, 0.5);
            animation: pulse 2s infinite ease-in-out; /* انیمیشن بزرگ شدن دایره */
            transition: all 0.3s ease-in-out;
        }

        .circle-info:hover {
            transform: scale(1.1);
            box-shadow: 0 0 50px rgba(255, 87, 34, 1), 0 0 30px rgba(0, 0, 0, 0.7);
        }

        .inner-circle {
            display: inline-block;
            background-color: #F4C2C2;
            border-radius: 50%;
            width: 160px;
            height: 160px;
            line-height: 160px;
            color: #ff5722;
            font-size: 2.5rem;
            font-weight: bold;
            margin-top: -10px;
            margin-left: -10px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-shadow: 0 0 10px rgba(255, 87, 34, 0.8);
        }

        .separator {
            margin: 30px 0;
            border-top: 2px solid #ff5722;
            width: 100%;
        }

        .service-section {
            margin-top: 50px;
        }

        .service-box {
            background-color: #F4C2C2;
            border: 1px solid #333;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.6);
            transition: transform 0.3s ease, box-shadow 0.3s ease, background-color 0.3s ease;
            text-align: right;
            position: relative;
            height: auto;
            min-height: 300px;
        }

        .service-box:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.7);
            background-color: #F4C2C2;
        }

        .service-info {
            font-weight: bold;
            margin-bottom: 10px;
            white-space: pre-wrap;
            word-break: break-word;
            color: #fff;
            font-size: 1.1rem;
        }

        .copy-btn {
            background-color: #E07F7F;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
            width: 80%;
            text-align: center;
            font-size: 1.2rem;
            margin-top: 15px;
            position: absolute;
            bottom: 15px;
            left: 50%;
            transform: translateX(-50%);
        }

        .copy-btn:hover {
            background-color: #e64a19;
            transform: translateX(-50%) scale(1.1);
        }

        .no-services {
            font-size: 1.5rem;
            color: #ffcc80;
            margin-top: 50px;
        }

        .service-box p {
            font-size: 1.2rem;
        }

        .service-box:before {
            content: "Service";
            font-size: 1.4rem;
            font-weight: bold;
            color: #ff5722;
            position: absolute;
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #E07F7F;
            padding: 5px 10px;
            border-radius: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- عنوان سرویس‌های کاربر -->
        <h2>لیست سرویس‌های کاربر</h2>

        <!-- دایره اطلاعات کاربر -->
        <div class="circle-info-container">
            <div class="circle-info">
                <div class="inner-circle">
                    <?php echo $num_services; ?>
                </div>
                <span>تعداد کاربران</span>
            </div>
        </div>

        <!-- خط جداکننده -->
        <div class="separator"></div>

        <div class="service-section">
            <?php if (!empty($services)): ?>
                <?php foreach ($services as $service): 
                    $service_parts = explode(", ", trim($service));
                    ?>
                    <div class="service-box">
                        <?php foreach ($service_parts as $part): ?>
                            <p class="service-info"><?php echo htmlspecialchars($part); ?></p>
                        <?php endforeach; ?>
                        <button class="copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars(end($service_parts)); ?>')">کپی لینک</button>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="no-services">هیچ خدمتی یافت نشد.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function copyToClipboard(text) {
            const link = text.match(/Link: (.*)/)[1];
            navigator.clipboard.writeText(link).then(function() {
                alert('لینک کپی شد');
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }
    </script>
</body>
</html>
