<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

// خواندن اطلاعات ارسالی
$username = $_POST['username'];
$volume = $_POST['volume'];
$duration = $_POST['duration'];
$reset_usage = isset($_POST['reset_usage']) && $_POST['reset_usage'] == "1"; // بررسی چک‌باکس

// خواندن اطلاعات پنل
$panel_file = 'pannel/pannel.txt';
if (file_exists($panel_file)) {
    $panel_data = file($panel_file, FILE_IGNORE_NEW_LINES);
    $panel_url = $panel_data[0];
    $username_panel = $panel_data[1];
    $password_panel = $panel_data[2];
} else {
    die("فایل اطلاعات پنل یافت نشد.");
}

// تابع برای دریافت توکن
function token_panel($url, $username, $password) {
    $url_get_token = $url . '/api/admin/token';
    $data_token = array(
        'username' => $username,
        'password' => $password
    );
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data_token),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded',
            'accept: application/json'
        )
    );
    $curl_token = curl_init($url_get_token);
    curl_setopt_array($curl_token, $options);
    $token = curl_exec($curl_token);
    curl_close($curl_token);
    return json_decode($token, true);
}

// تابع برای بروزرسانی کاربر
function updateUser($username, $expire, $data_limit, $reset_usage, $panel_url, $access_token) {
    // آدرس API برای بروزرسانی کاربر
    $url = $panel_url . "/api/user/" . urlencode($username);

    // اگر بازنشانی حجم مصرفی فعال باشه
    if ($reset_usage) {
        $reset_data = array(
            "data_limit" => 0 // حجم رو به صفر می‌ذاریم
        );
        $payload_reset = json_encode($reset_data);
        $headers = array(
            "Content-Type: application/json",
            "Authorization: Bearer " . $access_token
        );
        $ch_reset = curl_init($url);
        curl_setopt($ch_reset, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch_reset, CURLOPT_POSTFIELDS, $payload_reset);
        curl_setopt($ch_reset, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch_reset, CURLOPT_HTTPHEADER, $headers);
        $response_reset = curl_exec($ch_reset);
        curl_close($ch_reset);

        // بررسی خطا در مرحله صفر کردن حجم
        $reset_response = json_decode($response_reset, true);
        if (!isset($reset_response['success']) || !$reset_response['success']) {
            return ['error' => 'خطا در صفر کردن حجم: ' . json_encode($reset_response)];
        }
    }

    // حالا حجم جدید و مدت زمان رو اعمال می‌کنیم
    $update_data = array(
        "expire" => $expire,
        "data_limit" => $data_limit // حجم جدید
    );
    $payload_update = json_encode($update_data);
    $ch_update = curl_init($url);
    curl_setopt($ch_update, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch_update, CURLOPT_POSTFIELDS, $payload_update);
    curl_setopt($ch_update, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_update, CURLOPT_HTTPHEADER, $headers);
    $response_update = curl_exec($ch_update);
    curl_close($ch_update);

    // برگشت پاسخ نهایی
    return json_decode($response_update, true);
}

// دریافت توکن
$token_response = token_panel($panel_url, $username_panel, $password_panel);
if (isset($token_response['access_token'])) {
    $access_token = $token_response['access_token'];
    $expire = time() + ($duration * 24 * 60 * 60);
    $data_limit = $volume * 1024 * 1024 * 1024;

    // بروزرسانی کاربر
    $update_response = updateUser($username, $expire, $data_limit, $reset_usage, $panel_url, $access_token);
    if (isset($update_response['success']) && $update_response['success']) {
        echo "کاربر با موفقیت تمدید شد.";
    } else {
        echo "خطا در تمدید کاربر: " . json_encode($update_response);
    }
} else {
    echo "خطا در دریافت توکن: " . json_encode($token_response);
}
?>