<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

$email = $_SESSION['email'];
$directory = 'services';
$file_path = "$directory/$email.txt";

// خواندن اطلاعات کاربر از فایل
if (file_exists($file_path)) {
    $lines = file($file_path, FILE_IGNORE_NEW_LINES);
    $users = [];
    foreach ($lines as $line) {
        // استخراج اسم کاربر از هر خط
        if (preg_match('/Username: (\w+)/', $line, $matches)) {
            $users[] = $matches[1];
        }
    }
} else {
    die("اطلاعاتی برای کاربر یافت نشد.");
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>انتخاب کاربر</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7;
            margin: 0;
            padding: 20px;
        }
        .user-list {
            list-style-type: none;
            padding: 0;
        }
        .user-item {
            background-color: #fff;
            margin: 10px 0;
            padding: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .user-item:hover {
            background-color: #f0f0f0;
            cursor: pointer;
        }
        form {
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <h1>لیست کاربران</h1>
    <ul class="user-list">
        <?php foreach ($users as $user): ?>
            <li class="user-item">
                <form action="extend_user.php" method="POST">
                    <input type="hidden" name="username" value="<?php echo htmlspecialchars($user); ?>">
                    <button type="submit"><?php echo htmlspecialchars($user); ?></button>
                </form>
            </li>
        <?php endforeach; ?>
    </ul>
</body>
</html>