<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $selected_config = $_POST['selected_config'];
    $email = $_SESSION['email'];

    echo '
    <!DOCTYPE html>
    <html lang="fa">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>تمدید کانفیگ</title>
        <style>
            body {
                background: linear-gradient(135deg, #ff80a5, #ffb3c6, #f7e6f9);
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
            }
            .service-box {
                background: rgba(255, 255, 255, 0.3);
                backdrop-filter: blur(10px);
                border-radius: 20px;
                padding: 30px;
                width: 500px;
                box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
                color: black;
                text-align: center;
            }
            .service-box h3 {
                margin-bottom: 30px;
                font-size: 28px;
                font-weight: bold;
            }
            .service-box input {
                width: 100%;
                padding: 10px;
                margin-bottom: 20px;
                border-radius: 8px;
                border: 1px solid #ccc;
                font-size: 16px;
            }
            .service-box button {
                background: linear-gradient(135deg, #ff758c, #ffb199);
                color: white;
                padding: 15px 25px;
                border: none;
                border-radius: 8px;
                font-size: 18px;
                cursor: pointer;
                transition: background 0.3s ease;
            }
            .service-box button:hover {
                background: linear-gradient(135deg, #ff6379, #ff9fa8);
            }
        </style>
    </head>
    <body>
        <div class="service-box">
            <h3>تمدید کانفیگ</h3>
            <form action="process_renew.php" method="POST">
                <input type="hidden" name="selected_config" value="' . htmlspecialchars($selected_config) . '">
                <input type="number" name="volume" placeholder="حجم جدید (گیگابایت)" required>
                <input type="number" name="duration" placeholder="مدت زمان جدید (روز)" required>
                <button type="submit">تمدید</button>
            </form>
        </div>
    </body>
    </html>';
}
?>