<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

$email = $_SESSION['email']; // گرفتن ایمیل از جلسه کاربر

// مسیر فایل limit.txt
$limitFilePath = 'limit/limit.txt';
$limit = 0; 

// خواندن فایل limit.txt
if (file_exists($limitFilePath)) {
    $lines = file($limitFilePath, FILE_IGNORE_NEW_LINES);
    foreach ($lines as $line) {
        list($userEmail, $userLimit) = explode(':', $line);
        if ($userEmail == $email) {
            $limit = (int)$userLimit;
            break;
        }
    }
}

// بررسی تعداد سرویس‌های کاربر
$servicesDir = 'services/';
$userServiceFile = $servicesDir . $email . '.txt';
$serviceCount = 0;

if (file_exists($userServiceFile)) {
    $serviceCount = count(file($userServiceFile, FILE_IGNORE_NEW_LINES));
}

// بررسی اینکه آیا لیمیت پر شده است
if ($serviceCount >= $limit) {
    $errorMessage = "لیمیت ساخت سرویس شما پر شده است.<br>جهت افزایش لیمیت با پشتیبانی در ارتباط باشید";
} else {
    $errorMessage = '';
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Service</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Lalezar&family=Roboto:wght@400;700&display=swap');

body {
    font-family: 'Roboto', sans-serif;
    background: linear-gradient(135deg, #ffb3c6, #ffd1e4); /* رنگ کالباسی روشن به جای نارنجی */
    color: #333;
    margin: 0;
    padding: 0;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    direction: rtl;
}

.container {
    background: linear-gradient(145deg, #e3b5c8, #e3b5c8);
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.4);
    width: 450px;
    text-align: center;
    animation: fadeIn 1s ease-in-out;
    display: flex;
    flex-direction: column;
    align-items: center;
}

h2 {
    font-family: 'Lalezar', cursive;
    font-size: 32px;
    color: #fff;
    margin-bottom: 20px;
    text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.6);
}

label {
    display: block;
    margin-bottom: 10px;
    font-size: 16px;
    color: #fff;
    font-weight: bold;
    text-align: right;
}

.form-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    width: 100%;
    background-color: #996a70;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
}

input, button {
    width: 90%;
    padding: 15px;
    margin-bottom: 20px;
    border: none;
    border-radius: 10px;
    background-color: #fff;
    color: #333;
    font-size: 16px;
    text-align: right;
    transition: all 0.3s ease;
}

input:focus, button:hover {
    border-color: #ff9e6b;
    background-color: #ff9e6b;
    color: white;
    box-shadow: 0 0 8px rgba(255, 156, 107, 0.7);
    transform: scale(1.05);
}

button {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 18px;
    border: 1px solid #ff6600;
    cursor: pointer;
    box-shadow: 0 4px 10px rgba(255, 111, 0, 0.2);
}

button:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: scale(1.05);
    box-shadow: 0 6px 15px rgba(255, 111, 0, 0.3);
}

.random-btn {
    margin-bottom: 20px;
    padding: 10px 20px;
    background-color: #ff9e6b;
    border: none;
    border-radius: 8px;
    color: #fff;
    font-size: 14px;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

.random-btn:hover {
    background-color: #ff6600;
}

.footer {
    text-align: center;
    margin-top: 20px;
    font-size: 14px;
    color: #eee;
}

.footer a {
    color: #ffeb3b;
    text-decoration: none;
    font-weight: bold;
}

.footer a:hover {
    text-decoration: underline;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.form-container input, 
.form-container label {
    text-align: right;
}

.form-container input::placeholder {
    color: #ff9e6b;
}

.form-container {
    background-color: rgba(255, 255, 255, 0.2);
    border-radius: 15px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
    backdrop-filter: blur(10px);
}

button {
    background: rgba(0, 0, 0, 0.1);
    color: white;
    font-size: 18px;
    border: none;
    border-radius: 12px;
    cursor: pointer;
    box-shadow: 0 4px 10px rgba(255, 111, 0, 0.1);
    transition: all 0.3s ease;
}

button:hover {
    background: rgba(0, 0, 0, 0.2);
    box-shadow: 0 6px 15px rgba(255, 111, 0, 0.2);
    transform: scale(1.1);
}

    </style>
</head>
<body>
    <div class="container">
        <h2>ساخت سرویس جدید</h2>
        
        <?php if ($errorMessage): ?>
            <div class="error-message">
                <?php echo $errorMessage; ?>
            </div>
        <?php else: ?>
            <div class="form-container">
                <form method="POST" action="create_service_process.php">
                    <button type="button" class="random-btn" onclick="generateRandomUsername()">رندوم</button>
                    <label for="username">نام کاربری:</label>
                    <input type="text" id="username" name="username" required placeholder="نام کاربری را وارد کنید">

                    <label for="volume">حجم (گیگابایت):</label>
                    <input type="number" id="volume" name="volume" required placeholder="مثال: 50">

                    <label for="duration">مدت زمان (روز):</label>
                    <input type="number" id="duration" name="duration" required placeholder="مثال: 30">

                    <button type="submit">ایجاد سرویس</button>
                </form>
            </div>
        <?php endif; ?>

        <div class="footer">
            <p>به پنل مدیریت خود خوش آمدید</p>
            <p><a href="dashboard.php">بازگشت به داشبورد</a></p>
        </div>
    </div>

    <script>
        function generateRandomUsername() {
            var username = '';
            var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
            for (var i = 0; i < 9; i++) {
                username += characters.charAt(Math.floor(Math.random() * characters.length));
            }
            document.getElementById('username').value = username;
        }
    </script>
</body>
</html>
