<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

// خواندن اطلاعات پنل از فایل
$panel_file = 'pannel/pannel.txt';
if (file_exists($panel_file)) {
    $panel_data = file($panel_file, FILE_IGNORE_NEW_LINES);
    $panel_url = $panel_data[0];
    $username_panel = $panel_data[1];
    $password_panel = $panel_data[2];
} else {
    die("فایل اطلاعات پنل یافت نشد.");
}

// تابع برای دریافت توکن از پنل مرزبان
function token_panel($url, $username, $password) {
    $url_get_token = $url . '/api/admin/token';
    $data_token = array(
        'username' => $username,
        'password' => $password
    );
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data_token),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded',
            'accept: application/json'
        )
    );
    $curl_token = curl_init($url_get_token);
    curl_setopt_array($curl_token, $options);
    $token = curl_exec($curl_token);

    if (curl_error($curl_token)) {
        file_put_contents('curl_errors.log', curl_error($curl_token) . "\n", FILE_APPEND);
        return ['error' => curl_error($curl_token)];
    }

    curl_close($curl_token);
    return json_decode($token, true);
}

// تابع برای ایجاد کاربر و دریافت لینک سابسکریپشن
function createUserAndGetLink($username, $expire, $data_limit, $panel_url, $access_token) {
    $url = $panel_url . "/api/user";
    $data = array(
        "proxies" => array(
            "vmess" => array(
                "alterId" => 0,
                "security" => "auto",
                "flow" => "none"
            ),
            "vless" => array(
                "flow" => 'xtls-rprx-vision'
            )
        ),
        "expire" => $expire,
        "data_limit" => $data_limit,
        "username" => $username
    );

    $payload = json_encode($data);

    $headers = array(
        "Content-Type: application/json",
        "Authorization: Bearer " . $access_token
    );

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);

    if (curl_error($ch)) {
        file_put_contents('curl_errors.log', curl_error($ch) . "\n", FILE_APPEND);
        return ['error' => curl_error($ch)];
    }

    curl_close($ch);
    $response_data = json_decode($response, true);

    if (isset($response_data['username'])) {
        return ['link' => $response_data['subscription_url']];
    } else {
        return ['error' => 'خطا در ایجاد کاربر: ' . json_encode($response_data)];
    }
}

// دریافت داده‌های ارسال شده از فرم
$username = $_POST['username'];
$volume = $_POST['volume'];
$duration = $_POST['duration'];
$email = $_SESSION['email'];

$token_response = token_panel($panel_url, $username_panel, $password_panel);

if (isset($token_response['access_token'])) {
    $access_token = $token_response['access_token'];

    $expire = time() + ($duration * 24 * 60 * 60);
    $data_limit = $volume * 1024 * 1024 * 1024;

    $link_response = createUserAndGetLink($username, $expire, $data_limit, $panel_url, $access_token);

    if (isset($link_response['link'])) {
        // تغییر دامنه ساب لینک
        $old_domain = "cloudytrwd.lyra-st.ir";
        $new_domain = "sub.sublinkvip.site";

        // تغییر دامنه در لینک
        $link = str_replace($old_domain, $new_domain, $link_response['link']);

        // ساخت مسیر ذخیره فایل در فولدر services
        $directory = 'services';
        if (!is_dir($directory)) {
            mkdir($directory, 0755, true);
        }

        // ذخیره در فایل به نام ایمیل کاربر
        $file_path = "$directory/$email.txt";
        $service_details = "Username: $username, Volume: $volume GB, Duration: $duration days, Link: $link\n";
        file_put_contents($file_path, $service_details, FILE_APPEND);

        echo '
        <style>
            body {
                background: linear-gradient(135deg, #ff80a5, #ffb3c6, #f7e6f9); /* تغییر رنگ گرادیانت */
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
            }
            .service-box {
                background: rgba(255, 255, 255, 0.3); /* پس‌زمینه شفاف */
                backdrop-filter: blur(10px); /* فیلتر بلور */
                border-radius: 20px; /* گوشه‌های نرم‌تر */
                padding: 30px;
                width: 500px; /* افزایش عرض مستطیل */
                box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
                color: black; /* تغییر رنگ متن به سیاه */
                text-align: center;
            }
            .service-box h3 {
                margin-bottom: 30px; /* افزایش فاصله */
                font-size: 28px;
                font-weight: bold;
            }
            .service-box p {
                margin: 8px 0;
                font-size: 18px; /* افزایش اندازه فونت */
            }
            .config-box {
                background-color: #333;
                border-radius: 15px; /* گوشه‌های نرم‌تر */
                padding: 20px;
                margin: 20px 0;
                text-align: left;
                color: white;
                font-size: 16px; /* افزایش اندازه فونت */
                word-wrap: break-word;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            }
            .copy-btn {
                background: linear-gradient(135deg, #ff758c, #ffb199); /* دکمه کپی لینک */
                color: white;
                padding: 15px 25px; /* بزرگتر کردن دکمه */
                margin-top: 20px;
                border: none;
                border-radius: 8px; /* گوشه‌های نرم‌تر */
                font-size: 18px; /* افزایش اندازه فونت */
                cursor: pointer;
                transition: background 0.3s ease;
            }
            .copy-btn:hover {
                background: linear-gradient(135deg, #ff6379, #ff9fa8);
            }
        </style>

        <div class="service-box">
            <h3>کانفیگ شما آماده است</h3>
            <p><strong>نام کاربری:</strong> ' . $username . '</p>
            <p><strong>حجم:</strong> ' . $volume . ' گیگابایت</p>
            <p><strong>مدت زمان:</strong> ' . $duration . ' روز</p>

            <div class="config-box">
                <strong>لینک سابسکریپشن:</strong><br>
                ' . $link . '
            </div>

            <button class="copy-btn" onclick="copyToClipboard()">کپی لینک</button>
        </div>

        <script>
            function copyToClipboard() {
                const link = "' . $link . '";
                navigator.clipboard.writeText(link).then(() => {
                    alert("لینک سابسکریپشن کپی شد!");
                }).catch(err => {
                    alert("خطایی در کپی لینک رخ داد: " + err);
                });
            }
        </script>';
    } else {
        echo "خطا در دریافت لینک: " . $link_response['error'];
    }
} else {
    echo "خطا در دریافت توکن: " . json_encode($token_response);
}
?>