<?php
session_start();
if (!isset($_SESSION['email'])) {
    header('Location: login.php');
    exit;
}

$email = $_SESSION['email'];
$panel_file = 'pannel/pannel.txt';

if (file_exists($panel_file)) {
    $panel_data = file($panel_file, FILE_IGNORE_NEW_LINES);
    $panel_url = $panel_data[0];
    $username_panel = $panel_data[1];
    $password_panel = $panel_data[2];
} else {
    die("فایل اطلاعات پنل یافت نشد.");
}

// تابع دریافت توکن
function token_panel($url, $username, $password) {
    $url_get_token = $url . '/api/admin/token';
    $data_token = array(
        'username' => $username,
        'password' => $password
    );
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data_token),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded',
            'accept: application/json'
        )
    );
    $curl_token = curl_init($url_get_token);
    curl_setopt_array($curl_token, $options);
    $token = curl_exec($curl_token);

    if (curl_error($curl_token)) {
        return ['error' => curl_error($curl_token)];
    }
    curl_close($curl_token);
    return json_decode($token, true);
}

// تابع ایجاد کاربر
function createUserAndGetLink($username, $panel_url, $access_token) {
    $url = $panel_url . "/api/user";
    $data = array(
        "proxies" => array(
            "vmess" => array(
                "alterId" => 0,
                "security" => "auto",
                "flow" => "none"
            ),
            "vless" => array(
                "flow" => 'xtls-rprx-vision'
            )
        ),
        "expire" => time() + (1 * 24 * 60 * 60),
        "data_limit" => 1 * 1024 * 1024 * 1024,
        "username" => $username
    );

    $payload = json_encode($data);

    $headers = array(
        "Content-Type: application/json",
        "Authorization: Bearer " . $access_token
    );

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);

    if (curl_error($ch)) {
        return ['error' => curl_error($ch)];
    }
    curl_close($ch);
    $response_data = json_decode($response, true);

    if (isset($response_data['username'])) {
        return ['link' => $response_data['subscription_url']];
    } else {
        return ['error' => 'خطا در ایجاد کاربر: ' . json_encode($response_data)];
    }
}

// پردازش اطلاعات ارسالی
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['username'])) {
    $username = $_POST['username'];

    $token_response = token_panel($panel_url, $username_panel, $password_panel);

    if (isset($token_response['access_token'])) {
        $access_token = $token_response['access_token'];

        $link_response = createUserAndGetLink($username, $panel_url, $access_token);

        if (isset($link_response['link'])) {
            $link = $link_response['link'];

            // تغییر دامنه ساب لینک
            $old_domain = "cloudytrwd.lyra-st.ir";
            $new_domain = "sub.sublinkvip.site";

            // تغییر دامنه در لینک
            $link = str_replace($old_domain, $new_domain, $link);

            // ذخیره‌سازی لینک در فایل
            $directory = 'testservice';
            if (!is_dir($directory)) {
                mkdir($directory, 0755, true);
            }

            $file_path = "$directory/$email.txt";
            $service_details = "Username: $username, Volume: 1 GB, Duration: 1 day, Link: $link\n";
            file_put_contents($file_path, $service_details, FILE_APPEND);

            echo '
            <!DOCTYPE html>
            <html lang="fa">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>تحویل کانفیگ</title>
                <style>
                    body {
                        background: linear-gradient(135deg, #ff758c, #ffb199);
                        font-family: Arial, sans-serif;
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        height: 100vh;
                        margin: 0;
                    }
                    .config-box {
                        background: rgba(255, 255, 255, 0.3);
                        backdrop-filter: blur(10px);
                        border-radius: 15px;
                        padding: 30px;
                        text-align: center;
                        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
                        width: 450px;
                    }
                    .config-box h2 {
                        margin-bottom: 20px;
                    }
                    .config-box .details {
                        background-color: #fff;
                        padding: 15px;
                        border-radius: 8px;
                        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                        margin-bottom: 20px;
                    }
                    .config-box .details p {
                        margin: 5px 0;
                    }
                    .config-box button {
                        background: linear-gradient(135deg, #6a11cb, #2575fc);
                        color: white;
                        padding: 10px 20px;
                        border: none;
                        border-radius: 5px;
                        cursor: pointer;
                        margin-top: 10px;
                    }
                    .config-box button:hover {
                        background: linear-gradient(135deg, #3a0ca3, #3b82f6);
                    }
                    .config-box .copy-btn {
                        background: #00bcd4;
                    }
                    .config-box .copy-btn:hover {
                        background: #0097a7;
                    }
                    .config-box .view-btn {
                        background: #ff5722;
                    }
                    .config-box .view-btn:hover {
                        background: #e64a19;
                    }
                    .config-box input {
                        width: 100%;
                        padding: 8px;
                        margin: 10px 0;
                        border-radius: 5px;
                        border: 1px solid #ccc;
                    }
                </style>
                <script>
                    function copyLink() {
                        var copyText = document.getElementById("link");
                        copyText.select();
                        document.execCommand("copy");
                    }

                    function openLink() {
                        window.open("' . $link . '", "_blank");
                    }
                </script>
            </head>
            <body>
                <div class="config-box">
                    <h2>کانفیگ شما آماده است</h2>
                    <div class="details">
                        <p><strong>نام کاربری:</strong> ' . $username . '</p>
                        <p><strong>حجم:</strong> 1 GB</p>
                        <p><strong>زمان:</strong> 1 روز</p>
                    </div>
                    <input type="text" id="link" value="' . $link . '" readonly>
                    <button class="copy-btn" onclick="copyLink()">کپی لینک</button>
                    <button class="view-btn" onclick="openLink()">مشاهده اطلاعات</button>
                </div>
            </body>
            </html>';
        } else {
            echo "خطا در دریافت لینک: " . $link_response['error'];
        }
    } else {
        echo "خطا در دریافت توکن: " . json_encode($token_response);
    }
}
?>
